# coding=utf-8
from django.core.management import BaseCommand

from answer.models import Question
from api.models.user import UserExtra


class Command(BaseCommand):
    """
    同步api_userextra表中city_id到api_question的city_id
    """

    def handle(self, *args, **options):
        user_ids = Question.objects.values_list('user_id', flat=True).distinct()

        print 'get user id : done'
        city_info = UserExtra.objects.filter(user_id__in=user_ids, city_id__isnull = False).values('user_id', 'city_id')

        print 'get city info : done'
        print 'start update'
        for item in city_info:
            Question.objects.filter(user_id=item['user_id']).update(city_id=item['city_id'])
        print 'end update'