# coding=utf-8
# create by oldman at 17/3/26
from django.core.management import BaseCommand
from django.db import transaction

from api.models import Service, ServiceRegisterItem


class Command(BaseCommand):
    """
    处理没有关联美购注册的serviceitem
    python manaage.py update_20170326_set_serviceitem
    """

    def handle(self, *args, **options):
        set_offline = [5143926, 5144129, 5353113, 5420945]  # 将这些美购下线
        Service.objects.filter(id__in=set_offline).update(is_online=False)

        list_dict = [
            {
                'serviceitem_id': 46943,
                'serviceregisteritem_id': 40790,
                'service_id': 5199062,
            },

            {
                'serviceitem_id': 47853,
                'serviceregisteritem_id': 41766,
                'service_id': 5207421,
            },

            {
                'serviceitem_id': 53091,
                'serviceregisteritem_id': 48725,
                'service_id': 5244114,
            },

            {
                'serviceitem_id': 53092,
                'serviceregisteritem_id': 48726,
                'service_id': 5244114,
            },

            {
                'serviceitem_id': 53093,
                'serviceregisteritem_id': 48727,
                'service_id': 5244114,
            },

            {
                'serviceitem_id': 53094,
                'serviceregisteritem_id': 48728,
                'service_id': 5244114,
            },

            {
                'serviceitem_id': 53095,
                'serviceregisteritem_id': 48729,
                'service_id': 5244114,
            },

            {
                'serviceitem_id': 53096,
                'serviceregisteritem_id': 48730,
                'service_id': 5244114,
            },

            {
                'serviceitem_id': 53962,
                'serviceregisteritem_id': 49689,
                'service_id': 5251500,
            },

            {
                'serviceitem_id': 53963,
                'serviceregisteritem_id': 49690,
                'service_id': 5251500,
            },

        ]

        for item in list_dict:
            try:
                with transaction.atomic():
                    service_id = item.get('service_id')
                    serviceitem_id = item.get('serviceitem_id')
                    serviceregisteritem_id = item.get('serviceregisteritem_id')
                    service = Service.objects.get(id=service_id)
                    service.is_online = False
                    service.save()
                    serviceregisteritem = ServiceRegisterItem.objects.get(id=serviceregisteritem_id)
                    serviceregisteritem.serviceitem_id = serviceitem_id
                    serviceregisteritem.save()
                    print serviceregisteritem_id, serviceitem_id, service_id
            except Exception as e:
                print e.message

        print 'Done'
