# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models.consult import ConsultWiki


class ConsultWikiDB(DataBuilder):
    def getval_wiki_name(self, obj):
        return obj.wiki.item_name if obj.wiki else ''


@DB
class ConsultWikiDQ(DataSQLQuery):
        model = ConsultWiki
        data_model = ConsultWikiDB
