# coding=utf-8
# create by oldman at 2018/8/10
from django.core.management import BaseCommand
from django.db import transaction

from hippo.models import Doctor
from hippo.models import Merchant
from maidan.tasks.statement_task import create_one_statement
from pay.tool import DatetimeTool
from pay.tasks.statement_task import create_one_statement as service_statemnent
from pay.tasks.create_all_statement_task import create_one_statement as all_create_one_statement

class Command(BaseCommand):
    """
    单独为某一个商户跑对账单
    python manage.py update_2018_08_10_update_every_merchant_statement.py
    """
    def handle(self, *args, **options):
        doctor_ids = [u'61d54c916f0f46bbaeaf201da111335e',
                      u'6934cb85c02540978898f8883b85e982',
                      u'96d8b27b52064893b8c261ca865d3c94',
                      u'e0986e0ad558418d818c12b445f8252a',
                      u'f1b6382fcbbd4db3812eae3c55849984',
                      u'5699e3523c9b4acabddeb0ca46eac22e',
                      u'6218c93bbe9249d68083337e47461279',
                      u'fd4f7e9a310d11e6836b00163e00062b',
                      u'4e92ec7063cb4fa18086eeefa08da913'
                      ]
        last_month_dt = DatetimeTool().get_first_day_month(d_months=-1)
        for doctor_id in doctor_ids:
            try:
                with transaction.atomic():
                    doctor = Doctor.objects.get(id=doctor_id)
                    merchant = Merchant.objects.get(doctor_id=doctor.id, is_online=True)
                    create_one_statement(doctor, last_month_dt)
                    service_statemnent(doctor, last_month_dt)
                    all_create_one_statement(doctor, last_month_dt)
                print(u'{}：处理完成'.format(doctor.name))
            except Exception as e:
                print doctor_id
                print e

                continue


