# coding=utf-8
from django.core.management import BaseCommand
from api.models.service import Service, ServiceTag
from api.models.itemwiki import ItemWiki


class Command(BaseCommand):

    def handle(self, *args, **options):
        file_log = open('instance.txt', 'r')
        result_log = open('service_instance.txt', 'a')
        tags = []
        for wiki_id in file_log:
            tag_id = ItemWiki.objects.get(id=wiki_id).tag_id
            tags.append(tag_id)
        try:
            services = Service.objects.filter(tags__id__in=tags, is_online=True,
                                              doctor__hospital__city__province__country__id='china')
            for service in services:
                print service.id
                message = '%s,%s,%s,%s' % (service.id, service.is_stage, service.user_safe, service.is_insurance)
                result_log.writelines(message)
                service.is_stage = False
                service.user_safe = False
                service.is_insurance = True
                service.save()
        except Exception as e:
            print e.message
        print (u"处理完成!!")
        file_log.close()
        result_log.close()
