# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
from django.conf import settings
import rpc.tool.dict_mixin


class Migration(migrations.Migration):

    dependencies = [
        ('talos', '__first__'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BackendGroup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(unique=True, max_length=100, verbose_name='\u7ec4\u540d')),
                ('title', models.CharField(max_length=100, verbose_name='\u7ec4\u6807\u9898')),
                ('leader', models.ForeignKey(related_name='own_groups', verbose_name='\u7ec4\u957f', to=settings.AUTH_USER_MODEL, null=True)),
                ('members', models.ManyToManyField(related_name='belong_groups', verbose_name='\u7ec4\u5185\u6210\u5458', to=settings.AUTH_USER_MODEL, blank=True)),
            ],
            bases=(rpc.tool.dict_mixin.DictMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BackendModule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(unique=True, max_length=100, verbose_name='\u6a21\u5757\u540d')),
                ('title', models.CharField(max_length=100, verbose_name='\u6a21\u5757\u540d\u79f0')),
            ],
            bases=(rpc.tool.dict_mixin.DictMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BackendPermission',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100, verbose_name='\u6743\u9650\u540d')),
                ('title', models.CharField(max_length=100, verbose_name='\u6743\u9650\u540d\u79f0')),
                ('module', models.ForeignKey(verbose_name='\u6240\u5c5e\u6a21\u5757', to='hera.BackendModule')),
            ],
            bases=(rpc.tool.dict_mixin.DictMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Config',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('key', models.CharField(max_length=200, choices=[[b'point_4', '\u7f8e\u5206\u5546\u57ce\u7b2c4\u4f4d\u7f6e'], [b'point_1', '\u7f8e\u5206\u5546\u57ce\u7b2c1\u4f4d\u7f6e'], [b'point_2', '\u7f8e\u5206\u5546\u57ce\u7b2c2\u4f4d\u7f6e'], [b'point_3', '\u7f8e\u5206\u5546\u57ce\u7b2c3\u4f4d\u7f6e']])),
                ('value', models.TextField()),
            ],
            options={
                'verbose_name': '\u914d\u7f6e',
            },
        ),
        migrations.CreateModel(
            name='DiaryTagsVM',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('vm_updated_time', models.DateTimeField(auto_now=True, verbose_name='\u6700\u540e\u66f4\u65b0\u65f6\u95f4')),
                ('tag_id', models.IntegerField(verbose_name='Tag id')),
            ],
            options={
                'db_table': 'hera_vm_diary_tags',
                'verbose_name': '\u65e5\u8bb0\u672cTag\u5173\u8054',
            },
        ),
        migrations.CreateModel(
            name='DiaryVM',
            fields=[
                ('vm_updated_time', models.DateTimeField(auto_now=True, verbose_name='\u6700\u540e\u66f4\u65b0\u65f6\u95f4')),
                ('id', models.IntegerField(serialize=False, verbose_name='\u65e5\u8bb0\u672cid', primary_key=True)),
                ('title', models.CharField(default=b'', max_length=128, verbose_name='\u6807\u9898', db_index=True)),
                ('created_time', models.DateTimeField(verbose_name='\u521b\u5efa\u65f6\u95f4', db_index=True)),
                ('last_modified', models.DateTimeField(verbose_name='\u6700\u540e\u4fee\u6539\u65f6\u95f4', db_index=True)),
                ('last_topic_add_time', models.DateTimeField(null=True, verbose_name='\u6700\u540e\u53d1\u5e16\u65f6\u95f4', db_index=True)),
                ('price', models.IntegerField(default=0, verbose_name='\u4ef7\u683c', db_index=True)),
                ('reply_num', models.IntegerField(default=0, verbose_name='\u56de\u590d\u6570\u91cf', db_index=True)),
                ('rating', models.FloatField(default=0, verbose_name='\u8bc4\u4ef7', db_index=True)),
                ('is_online', models.BooleanField(default=True, verbose_name='\u662f\u5426\u4e0a\u7ebf')),
                ('is_real_case', models.BooleanField(default=False, verbose_name='\u771f\u4eba\u6848\u4f8b')),
                ('is_sink', models.BooleanField(default=False, verbose_name='\u662f\u5426\u4e0b\u6c89')),
                ('operation_time', models.DateTimeField(null=True, verbose_name='\u624b\u672f\u65f6\u95f4', db_index=True)),
                ('is_headline', models.BooleanField(default=False, verbose_name='\u9996\u9875\u63a8\u8350')),
                ('is_essence', models.BooleanField(default=False, verbose_name='\u7cbe\u534e\u5e16')),
                ('content_level', models.CharField(default='0', max_length=1, verbose_name='\u5185\u5bb9\u7b49\u7ea7', choices=[('0', '\u672a\u5ba1\u6838'), ('1', '\u4e0d\u5408\u89c4'), ('3', '\u4e00\u822c'), ('3.5', '\u8f83\u597d'), ('2', '\u5dee'), ('5', '\u4f18\u79c0'), ('4', '\u826f\u597d')])),
                ('audit_status', models.CharField(default='0', max_length=1, verbose_name='\u5ba1\u6838\u72b6\u6001', choices=[('0', '\u672a\u5ba1\u6838'), ('1', '\u518d\u5ba1\u6838'), ('2', '\u5df2\u5ba1\u6838')])),
                ('audit_time', models.DateTimeField(null=True, verbose_name='\u6700\u7ec8\u5ba1\u6838\u65f6\u95f4')),
                ('not_empty', models.BooleanField(default=False, verbose_name='\u975e\u7a7a\u65e5\u8bb0\u672c')),
                ('not_review_topic_num', models.IntegerField(default=0, verbose_name='\u672a\u5ba1\u6838\u5e16\u5b50\u6570')),
                ('user_id', models.IntegerField(verbose_name='\u7528\u6237id', db_index=True)),
                ('user_nickname', models.CharField(max_length=30, verbose_name='\u7528\u6237\u6635\u79f0', db_index=True)),
                ('doctor_id', models.CharField(max_length=100, null=True, verbose_name='\u533b\u751fid', db_index=True)),
                ('doctor_name', models.CharField(default=b'', max_length=200, verbose_name='\u533b\u751f\u540d\u79f0', db_index=True)),
                ('hospital_id', models.CharField(max_length=100, null=True, verbose_name='\u533b\u9662id', db_index=True)),
                ('hospital_name', models.CharField(default=b'', max_length=100, verbose_name='\u533b\u9662\u540d\u79f0', db_index=True)),
                ('order_id', models.CharField(max_length=12, null=True, verbose_name='\u8ba2\u5355id', db_index=True)),
                ('order_is_self_support', models.BooleanField(default=True, verbose_name='\u8ba2\u5355\u81ea\u8425')),
                ('order_status', models.CharField(default='0', max_length=20, null=True, verbose_name='\u8ba2\u5355\u72b6\u6001', choices=[('0', '\u672a\u4ed8\u6b3e'), ('10', '\u4ed8\u6b3e\u4e2d'), ('2', '\u5df2\u4f7f\u7528'), ('6', '\u9000\u6b3e\u5904\u7406\u4e2d'), ('3', '\u5df2\u9000\u6b3e'), ('1', '\u5df2\u4ed8\u6b3e'), ('9', '\u7ed3\u7b97\u4e2d'), ('7', '\u5176\u5b83'), ('5', '\u5df2\u53d6\u6d88'), ('8', '\u5ba1\u6838\u4e2d'), ('4', '\u5df2\u7ed3\u7b97')])),
                ('order_cash_back_status', models.CharField(default='0', max_length=1, null=True, verbose_name='\u8fd4\u73b0\u72b6\u6001', choices=[('0', '\u7533\u8bf7\u8fd4\u73b0'), ('2', '\u5df2\u8fd4\u73b0'), ('1', '\u8fd4\u73b0\u5ba1\u6838\u4e2d')])),
                ('order_validated', models.BooleanField(default=False)),
                ('order_cashback_id', models.CharField(max_length=15, null=True, verbose_name='\u8fd4\u73b0id', db_index=True)),
                ('order_cashback_time', models.DateTimeField(null=True, verbose_name='\u8fd4\u73b0\u65f6\u95f4')),
                ('service_id', models.IntegerField(null=True, verbose_name='\u7f8e\u8d2did', db_index=True)),
                ('service_name', models.CharField(default=b'', max_length=100, verbose_name='\u7f8e\u8d2d\u540d\u79f0', db_index=True)),
                ('service_is_online', models.BooleanField(default=True, verbose_name='\u7f8e\u8d2d\u4e0a\u7ebf')),
                ('diaryrank_id', models.IntegerField(null=True, verbose_name='\u65e5\u8bb0\u672c\u9996\u9875\u6392\u5e8f\u5206\u503cid')),
                ('diaryrank_additional_score', models.IntegerField(default=0, verbose_name='\u9644\u52a0\u5206\u6570')),
                ('relobj', models.ForeignKey(to='talos.Diary')),
            ],
            options={
                'db_table': 'hera_vm_diary',
                'verbose_name': '\u65e5\u8bb0\u672c\u89c6\u56femodel',
            },
        ),
        migrations.CreateModel(
            name='SendEmailTaskLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('task_id', models.CharField(max_length=50, verbose_name='\u4efb\u52a1id')),
                ('user_id', models.IntegerField(verbose_name='\u7528\u6237ID')),
                ('user_name', models.CharField(max_length=100, verbose_name='\u7528\u6237\u540d')),
                ('send_email', models.CharField(max_length=100, verbose_name='\u53d1\u9001\u90ae\u7bb1')),
                ('title', models.CharField(max_length=100, verbose_name='\u5bfc\u51fa\u6807\u9898')),
                ('status', models.CharField(default='PENDING', max_length=100, verbose_name='\u72b6\u6001', choices=[('STARTED', '\u5f00\u59cb\u6267\u884c'), ('FAILURE', '\u6267\u884c\u5931\u8d25'), ('PENDING', '\u51c6\u5907\u4e2d'), ('SUCCESS', '\u6267\u884c\u6210\u529f'), ('PROGRESS', '\u6267\u884c\u4e2d')])),
                ('join_time', models.DateTimeField(auto_now_add=True, verbose_name='\u52a0\u5165\u65f6\u95f4')),
                ('start_time', models.DateTimeField(null=True, verbose_name='\u5f00\u59cb\u65f6\u95f4', blank=True)),
                ('end_time', models.DateTimeField(null=True, verbose_name='\u7ed3\u675f\u65f6\u95f4', blank=True)),
                ('options', models.TextField(verbose_name='\u7b5b\u9009\u6761\u4ef6')),
                ('current', models.IntegerField(default=0, verbose_name='\u4f4d\u7f6e')),
                ('total', models.IntegerField(default=0, verbose_name='\u603b\u6570')),
            ],
        ),
        migrations.AddField(
            model_name='diarytagsvm',
            name='diary',
            field=models.ForeignKey(related_name='rel_tags', to='hera.DiaryVM'),
        ),
        migrations.AddField(
            model_name='backendgroup',
            name='permissions',
            field=models.ManyToManyField(to='hera.BackendPermission', blank=True),
        ),
        migrations.AlterUniqueTogether(
            name='backendpermission',
            unique_together=set([('name', 'module')]),
        ),
    ]
