# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import TicketsResult


class TicketsResultDB(DataBuilder):
    def getval_is_valid(self, obj):
        return True if obj.tickets_set.exists() or obj.ticketsresultrecord_set.exists() else False


@DB
class TicketsResultDQ(DataSQLQuery):
    model = TicketsResult
    data_model = TicketsResultDB

    def filter_is_valid(self, srch_key, srch_val, regex=False):
        q = Q(sink_days=0) & Q(ticketsresultrecord__isnull=True)
        return ~q if srch_val else q
