# -*- coding: UTF-8 -*-

from rpc.decorators import bind_context
from rpc.exceptions import RPCNotFoundException
from rpc.tool.dict_mixin import to_dict
from api.models import IndustryNews
from rpc.tool.log_tool import logging_exception
from hera.queries.industrynews import IndustryNewsDQ
from hera.utils import model_edit

uri_pre = 'hera/industrynews'


@bind_context(uri_pre + '/get')
def industrynews_detail(ctx, industrynews_id, options=None):
    try:
        industrynews = IndustryNews.objects.get(id=industrynews_id)
    except:
        raise RPCNotFoundException
    if options is None:
        options = {
            'fields': None,
            'excludes': None,
            'expands': None,
        }
    data = to_dict(industrynews, **options)
    return data


@bind_context(uri_pre + '/edit')
def industrynews_edit(ctx, industrynews_id=None, industrynews_info=None):
    if industrynews_info is None:
        return None
    if not industrynews_info['end_time']:
        industrynews_info['end_time'] = None
    industrynews = model_edit(IndustryNews, industrynews_id, industrynews_info)
    return {'id': industrynews.id}


@bind_context(uri_pre + '/query')
def industrynews_query(ctx, options):
    dqobj = IndustryNewsDQ()
    return dqobj.process(**options)
