#! /usr/bin/env python
# -*- coding: utf-8 -*-
# create by oldman
# Date: 2018/10/15
import json

from gm_types.gaia import DOCTOR_TYPE

from api.tool.image_utils import get_full_path
from hippo.models import Doctor, HospitalRestAssured, HospitalSpecialService
from hippo.models import HospitalInstrument
from hippo.models import Hospital_Extra
from hippo.models import Merchant
from hippo.models import MerchantLicense
from rpc.tool.dict_mixin import to_dict


def get_hospital_info(hospital):
    """
    获取医院更多信息 7725机构主页改版
    :return:
    """
    hospital_extra = Hospital_Extra.objects.filter(hospital=hospital).first()
    doctor = Doctor.objects.filter(hospital=hospital, doctor_type=DOCTOR_TYPE.OFFICER).first()
    merchant = Merchant.objects.filter(doctor=doctor, is_online=True).first()
    merchant_lincense = MerchantLicense.objects.filter(merchant=merchant).first()
    hospitalinstrument = HospitalInstrument.objects.filter(hospital=hospital).first()
    video_info = hospital.video_info
    # rest_assured = hospital.rest_assured.first()
    # special_service = hospital.special_service.first()
    bese_info = {
        'hospital_extra': to_dict(hospital_extra) if hospital_extra else {},
        'hospital_images': list(hospital.organizationimage_set.values_list("image_url", flat=True)),
        'business_area': hospital_extra.business_area if hospital_extra else '',
        'department_count': hospital_extra.department_count if hospital_extra else None,
        'bed_count': hospital_extra.bed_count if hospital_extra else None,
        'description': hospital.description,
        'honor_introduction': hospital_extra.honor_introduction if hospital_extra else '',
        'honor_pics': doctor.honor_pics if doctor else [],
        'merchant_lincense': get_full_path(merchant_lincense.lincense_img, '-wwtm') if merchant_lincense else '',  # 营业执照
        'p_licences': get_full_path(doctor.p_licences[0], '-wwtm') if doctor and doctor.p_licences else '',  # 医疗执业许可证
        'hospitalinstrument_intro': hospitalinstrument.intro if hospitalinstrument else '',  # 仪器介绍
        'hospitalinstrument_pics': [item['detail_image'] for item in
                                    json.loads(hospitalinstrument.content)] if hospitalinstrument else [],
        'video_url': video_info['video_url'],
        'video_pic': video_info['video_pic'],
        # "rest_assured": rest_assured.to_dict() if rest_assured else HospitalRestAssured.default_value_to_dict(),
        # "special_service": special_service.to_dict()
        # if special_service else HospitalSpecialService.default_value_to_dict(),
    }
    return bese_info
