#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   18/04/08 17:36:07
#   Desc    :   给所有没有内容聚合的tag创造默认聚合
#

from django.core.management import BaseCommand

from api.models import Tag
from polymer.models import Polymer, PolymerTab

from gm_types.gaia import POLYMER_DETAIL_TAB_TYPE as TAB
from gm_types.gaia import TAG_TYPE as TAG


class Command(BaseCommand):
    def handle(self, *args, **options):
        for tag in Tag.objects.filter(polymer__isnull=True):
            tag.tag_type and self.create_tag_polymer(tag)

    def create_tag_polymer(self, tag):
        print(u'create tag polymer {}:{}'.format(tag.id, tag.name))
        tabs = [TAB.DIARY, TAB.SERVICE, TAB.KNOWLAGE, TAB.DOCTOR, TAB.HOSPITAL]
        T1 = ([True, True, False, True, True], TAB.DIARY)
        T2 = ([True, False, False, False, False], TAB.DIARY)
        T3 = ([False, False, True, False, False], TAB.KNOWLAGE)
        T4 = ([True, True, False, False, False], TAB.DIARY)
        enables, default_tab = {
            TAG.BODY_PART: T1, TAG.BODY_PART_SUB_ITEM: T1, TAG.ITEM_WIKI: T1,
            TAG.DOCTOR: T2, TAG.HOSPITAL: T2, TAG.CHANNEL: T2,
            TAG.YUNYING: T3, TAG.FREE: T3,
            TAG.CITY: T4, TAG.PROVINCE: T4, TAG.COUNTRY: T4,
        }[tag.tag_type]
        if not Polymer.objects.filter(tags__id=tag.id).exists():
            p = Polymer.objects.create(name=tag.name, default_tab=default_tab)
            p.tags = [tag]
            for tab_type, enable in zip(tabs, enables):
                PolymerTab.objects.create(polymer=p, tab_type=tab_type, enable=enable)
