-- Deploy gaia:2017_07_06_add_budan to mysql

BEGIN;

CREATE TABLE `api_budansettlement` (
    `id` varchar(12) NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `extra_consume` double precision(11,2) NOT NULL,
    `payment` double precision(11,2) NOT NULL,
    `fine` double precision(11,2) NOT NULL,
    `status` smallint NOT NULL,
    `month_at` date NOT NULL,
    `created_at` datetime(2) NOT NULL
)
;
ALTER TABLE `api_budansettlement` ADD CONSTRAINT `doctor_id_refs_id_6c31dbaf` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `api_budan` (
    `id` varchar(12) NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `user_id` integer,
    `service_id` integer,
    `order_id` varchar(12),
    `settlement_id` varchar(12),
    `user_phone` varchar(20) NOT NULL,
    `dev_projects` varchar(500) NOT NULL,
    `extra_consume` double precision(11,2) NOT NULL,
    `payment` double precision(11,2) NOT NULL,
    `status` smallint NOT NULL,
    `platform` smallint NOT NULL,
    `create_user_id` integer NOT NULL,
    `comment` varchar(500) NOT NULL,
    `happen_time` datetime(6),
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_budan` ADD CONSTRAINT `doctor_id_refs_id_59f9ff71` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `api_budan` ADD CONSTRAINT `order_id_refs_id_d2066511` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
ALTER TABLE `api_budan` ADD CONSTRAINT `service_id_refs_id_c36c8a70` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `api_budan` ADD CONSTRAINT `settlement_id_refs_id_6f70f3c8` FOREIGN KEY (`settlement_id`) REFERENCES `api_budansettlement` (`id`);
ALTER TABLE `api_budan` ADD CONSTRAINT `user_id_refs_id_1b1395e4` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_budan` ADD CONSTRAINT `create_user_id_refs_id_1b1395e4` FOREIGN KEY (`create_user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_budanrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `budan_id` varchar(12) NOT NULL,
    `user_id` integer NOT NULL,
    `message` longtext NOT NULL,
    `role` smallint NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `operate` smallint NOT NULL
)
;
ALTER TABLE `api_budanrecord` ADD CONSTRAINT `budan_id_refs_id_82fc1633` FOREIGN KEY (`budan_id`) REFERENCES `api_budan` (`id`);
ALTER TABLE `api_budanrecord` ADD CONSTRAINT `user_id_refs_id_8077f845` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);

CREATE INDEX `api_budansettlement_72821be1` ON `api_budansettlement` (`doctor_id`);
CREATE INDEX `api_budan_72821be1` ON `api_budan` (`doctor_id`);
CREATE INDEX `api_budan_6340c63c` ON `api_budan` (`user_id`);
CREATE INDEX `api_budan_91a0ac17` ON `api_budan` (`service_id`);
CREATE INDEX `api_budan_68d25c7a` ON `api_budan` (`order_id`);
CREATE INDEX `api_budan_e8c21a4b` ON `api_budan` (`settlement_id`);
CREATE INDEX `api_budan_d8b25398` ON `api_budan` (`create_user_id`);
CREATE INDEX `api_budanrecord_8b223b59` ON `api_budanrecord` (`budan_id`);
CREATE INDEX `api_budanrecord_6340c63c` ON `api_budanrecord` (`user_id`);

COMMIT;
