# -*- coding: UTF-8 -*-

from gm_dataquery.dataquery import DataSQLQuery, DataBuilder
from gm_dataquery.db import DB

from wiki.models.collect import Collect, CollectItem
from wiki.logices.common_query import NewWikiRelationWords


class CollectDB(DataBuilder, NewWikiRelationWords):
    def getval_tags(self, obj):
        return list(obj.tags.values_list('tag_id', flat=True))

@DB
class CollectDQ(DataSQLQuery):
    model = Collect
    data_model = CollectDB

@DB
class CollectItemDQ(DataSQLQuery):
    model = CollectItem
