# -*- coding:utf-8 -*-

import math
import time
import datetime
from operator import itemgetter
from multiprocessing import Pool, Manager
from django.core.management.base import BaseCommand
from django import db

from api.models.doctor import Doctor
from api.models.sign_activity import SignActivity, UserLastSignRecord, UserLastSign, ActivityPrize


def get_activity_info():
    activity = SignActivity.objects.filter(is_online=True, start_time__lte=datetime.datetime.now(),
                                           end_time__gte=datetime.datetime.now()).first()
    if not activity:
        return {}

    activity_goods_list = ActivityPrize.objects.filter(activity_id=activity.id).values("prize_id", "cost", "count")

    goods_info_list = []
    for item in sorted(activity_goods_list, key=itemgetter("cost"), reverse=True):  # 按照兑换等级排序 倒序排
        _data = dict(item)
        goods_info_list.append(_data.get('cost'))

    return {"activity_id": activity.id, "goods": goods_info_list}


def transfer_data(result):

    user_ids = result.get('user_ids')
    prizes = result.get('prizes')
    activity_id = result.get('activity_id')

    user_ids = list(set(user_ids))
    for user_id in user_ids:
        doctor = Doctor.objects.filter(user_id=user_id)
        if doctor:
            continue

        user_sign = UserLastSignRecord.objects.filter(user_id=user_id).order_by('-available_days') \
                                              .values_list('available_days', flat=True)

        available_days = 0
        for user_record in user_sign:
            for prize in prizes:
                if user_record >= prize:
                    available_days += prize
                    break

        UserLastSign.objects.create(user_id=user_id, activity_id=activity_id,
                                    days_count=available_days, available_days=available_days)


class Command(BaseCommand):
    def handle(self, *args, **options):
        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)

        queue = Manager().Queue(maxsize=4)
        queue.put(0)  # 触发程序开始

        per_num = 200.0
        all_record = UserLastSignRecord.objects.all().values_list('user_id', flat=True).distinct()
        count = all_record.count()
        cnt = int(math.ceil(count / per_num))

        result = get_activity_info()
        if not result:
            return

        args_list = []
        for _ in range(cnt):
            args_list.append({'user_ids': list(all_record)[_*int(per_num):(_+1)*int(per_num)],
                              "activity_id": result.get('activity_id'), "prizes": result.get('goods')})
        db.connections.close_all()
        pool = Pool(processes=4)
        pool.map(transfer_data, args_list)
        pool.close()
        pool.join()
        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
