# -*- coding: UTF-8 -*-

from api.models.wordrel import WordRel, WordRelSynonym

from rpc.decorators import bind


@bind('api/keywords/iter')
def get_keywords(last_max_id=-1, count=10):
    word_objs = list(WordRel.objects.filter(id__gt=last_max_id).order_by('id')[:(count + 1)])

    result = dict()
    result['keywords'] = []
    result['has_next'] = len(word_objs) == (count + 1)

    word_objs = word_objs[:count]

    for obj in word_objs:
        item = {
            'id': obj.id,
            'keyword': obj.keyword,
            'resembles': list(obj.all_resembles.all().values_list('word', flat=True))
        }

        result['keywords'].append(item)

    return result


@bind('api/wordrel/synonym')
def get_keywords(word):
    """
    通过一个词获取它的所有同义词
    :param word:
    :return:
    """
    if WordRelSynonym.objects.filter(word=word).exists():
        keyword = WordRelSynonym.objects.filter(word=word).first().wordrel
        data = keyword.synonyms_word_list()
    else:
        data = []
    return data
