# coding: utf-8
import uuid

from celery import shared_task
from django.db import transaction
from django.db.models import F
from lasker.models import Vote, Participant


@shared_task()
def forge_vote(participant_id):
    """

    :param participant_id:
    :return:
    """
    # 增加事物操作
    with transaction.atomic():
        for i in range(3):
            Vote.objects.create(participant_id=participant_id, wx_uid=uuid.uuid4().hex, forged=True)

        Participant.objects.filter(pk=participant_id).update(votes_num=F('votes_num') + 3)
