# coding=utf-8
from __future__ import unicode_literals, absolute_import

import datetime

from django.db import models
from django.conf import settings

from gm_crypto.fields import EncryptedCharField
from api.models import User
from api.models import Order
from rpc.tool.time_tool import format_time


class PolicyHolder(models.Model):
    user = models.OneToOneField(User, verbose_name='policyholder')
    id_card = EncryptedCharField(u'用户第三方密码md5', max_length=18)
    name = EncryptedCharField(u'真实姓名', max_length=16)
    created_time = models.DateTimeField(auto_now_add=True, help_text=u"创建时间")

    @property
    def info(self):
        return {
           'user': self.user,
            'id_card': self.id_card,
            'name': self.name,
            'created_time': format_time(self.created_time, '%Y-%m-%d'),
        }

class YinuoOrder(models.Model):
    order = models.OneToOneField(Order, verbose_name='', related_name='yinuo_order')
    payment_id = models.CharField(max_length=16, verbose_name='一诺的付款单号')
    premium = models.IntegerField(verbose_name='保费', default=settings.YINUO_PREMIUM)
    yinuo_id = models.CharField(max_length=16, verbose_name='一诺订单号', null=True)  # guarantee_slip_id
    credential_id = models.CharField(max_length=40, verbose_name='保险公司保单号', null=True)
    confirmed_at = models.DateTimeField(verbose_name='出保时间', null=True)
    paid_at = models.DateTimeField(verbose_name='保单付款时间', null=True)
    created_at = models.DateTimeField(verbose_name='订单创建时间', null=True)
    expiration = models.IntegerField(verbose_name='保单有效期', default=210)

    @property
    def info(self):
        time_format = '%Y-%m-%d'
        return {
            'premium': self.premium,
            'yinuo_id': self.yinuo_id,
            'credential_id': self.credential_id,
            'confirmed_at': format_time(self.confirmed_at, time_format),
            'paid_at': format_time(self.paid_at, time_format),
            'created_at': format_time(self.created_at, time_format),
            'expiration': self.expiration,
            'begin_date': format_time(self.confirmed_at),
            'end_date': format_time(
                self.confirmed_at + datetime.timedelta(days=self.expiration)) if self.confirmed_at else ''
        }
