#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__: vv
# Date: 2019/11/7

from django.db import models
from django.db import transaction
from django.db import IntegrityError
from pay.tool import random_tool
from rpc.tool.log_tool import info_logger


class MerchantPayOrderManager(models.Manager):
    @transaction.atomic
    def create_merchantpay_order(self, merchant_id):
        while True:
            new_id = random_tool.generate_id(id_length=12)
            try:
                merchant_pay_order = self.create(
                    id=new_id,
                    merchant_id=merchant_id
                )
                return merchant_pay_order
            except IntegrityError:
                info_logger.warning("MerchantPayOrder Create Fail, new_id: " + new_id)
                pass
