# coding: utf-8

from django.db.models import Model
from django.db.models import BooleanField, DateTimeField, IntegerField

from gm_upload import ImgUrlField, IMG_TYPE


class PhotoStorage(Model):
    class Meta:
        verbose_name = u'图库'
        app_label = 'api'

    image = ImgUrlField('图片', img_type= IMG_TYPE.SPECIAL, max_length=255)
    type = IntegerField('类型', default=1)
    is_online = BooleanField("是否下线", default=True)
    create_time = DateTimeField("创建时间", auto_now_add=True)
