# coding=utf-8
from django.core.management import BaseCommand

from pay.models import Statement, StatementAccount

class Command(BaseCommand):
    """
    python manage.py insert_20170320_create_statement_account
    """

    def handle(self, *args, **options):
        statement_ids = [
            222334955305402,
            107380648453052,
            955029239998354,
            695121021840329,
            719716681619142,
            604544763244752,
            638962674724999,
            545765454340997,
            282514017012157,
            406799619699258,
            143776699245864,
            634386369604783,
            384565079278920,
        ]
        for statement_id in statement_ids:
            try:
                statement = Statement.objects.get(id=statement_id)
                doctor_account = statement.doctor.merchant.account
                statement_account_info = {
                    'statement': statement,
                    'province': doctor_account.province,
                    'city': doctor_account.city,
                    'bank': doctor_account.bank,
                    'account_name': doctor_account.account_name,
                    'account_number': doctor_account.account_number,
                    'account_type': doctor_account.account_type,
                }
                if not getattr(statement, 'account', None):
                    statementaccount = StatementAccount.objects.create(**statement_account_info)
                    print statement.id, statementaccount.id
            except Exception as e:
                print statement_id, e.message
                continue
            print 'DONE!'
