# coding=utf-8

import xlrd
from django.core.management import BaseCommand
from api.models import ServiceTag
from gm_types.gaia import TAG_TYPE

class Command(BaseCommand):
    """
    python manage.py insert_20190618_yunying_tag
    """

    def handle(self, *args, **options):
        tag_id = 9521
        data = xlrd.open_workbook('618_yunying_tag.xls'.decode('utf-8'))
        for table in data.sheets()[:1]:
            for row in range(1, table.nrows):
                r_info = table.row_values(row)
                service_id = r_info[2]
                try:
                    if service_id:
                        service_id = int(service_id)
                        ServiceTag.objects.filter(tag__tag_type=TAG_TYPE.YUNYING, service_id=service_id)
                        ServiceTag.objects.get_or_create(
                            service_id=service_id,
                            tag_id=tag_id
                        )
                        print 'service_id', service_id
                except Exception as e:
                    print 'error', 'service_id:', service_id, 'tag_id:', tag_id
                    print e
        print 'Done!'
