#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/7/4

from datetime import datetime
from django.core.management import BaseCommand
from api.models import BDTransfer
from gm_types.gaia import BDTRANSFER_OBJECT_STATE


class Command(BaseCommand):
    """ 更新 线上一批状态异常的 商务转诊记录表 为 "已成单" """
    def handle(self, *args, **options):

        bdtransfer_ids = BDTransfer.objects.filter(object_state=0).values_list("id", flat=True)
        bdtransfer_ids = list(bdtransfer_ids)
        print("to update bdtransfer_ids: ", bdtransfer_ids)

        BDTransfer.objects.filter(id__in=bdtransfer_ids).update(object_state=BDTRANSFER_OBJECT_STATE.SINGLE_FINISHED)

        print("done")
