# -*- coding: UTF-8 -*-

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import SideSkidCategory


class SideSkidCategoryDB(DataBuilder):
    def getval_tags_name(self, obj):
        tags_name = [t.name for t in obj.tags.all()]
        return ','.join(tags_name)


@DB
class SideSkidCategoryDQ(DataSQLQuery):
    model = SideSkidCategory
    data_model = SideSkidCategoryDB
