# coding=utf8
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.contrib.auth.models import User

from .types import TAG_TYPE
from .bodypart import BodyPart
from .channel import Channel
from .tag import Tag


class BodyPartSubItem(models.Model):
    """
    第二级分类
    """

    class Meta:
        verbose_name = u'12. 整形细分项目(二级分类)'
        verbose_name_plural = u'12. 整形细分项目(二级分类)'
        db_table = 'api_bodypartsubitem'
        app_label = 'api'

    name = models.CharField(max_length=30, help_text=u"第二级分类", db_index=True)
    body = models.ForeignKey(BodyPart, related_name='sub_items', null=True,
                             verbose_name=u'身体部位', help_text=u'一级分类')
    channel = models.ForeignKey(Channel, null=True, blank=True)
    is_deleted = models.BooleanField(default=False, help_text=u"是否标记删除")
    hint = models.TextField(default='', blank=True, null=True, help_text=u"提问提醒", verbose_name=u"提问提醒")
    rank = models.IntegerField(default=0, verbose_name=u"排序", help_text=u"越小越排在前面")
    users = models.ManyToManyField(User)
    is_recommend_followed = models.BooleanField(default=False, verbose_name=u"推荐关注")
    tag = models.ForeignKey(Tag, null=True, blank=True)

    def tag_data(self):
        return {
            'name': self.tag.name, 'id': self.id, 'tag_type': u'sub_item',
            'tag_id': self.tag.id,
        }

    def get_tag(self):
        return Tag.objects.get(name=self.name, tag_type=TAG_TYPE.BODY_PART_SUB_ITEM)

    def __unicode__(self):
        return self.name
