# coding=utf-8
from __future__ import unicode_literals
from celery import shared_task
from django.conf import settings
from gm_types.gaia import ORDER_STATUS, ORDER_OPERATION_ROLE, ORDER_OPERATION_TYPE
from api.models import Person
from maidan.models.order import MaidanOrder


@shared_task
def maidan_soft_time_out_event(maidan_order_id):
    order = MaidanOrder.objects.get(id=maidan_order_id)
    operator = Person.objects.get(user_id=settings.BOSS)
    if order.status == ORDER_STATUS.NOT_PAID:
        order.operate(operator, ORDER_OPERATION_TYPE.CANCEL, ORDER_OPERATION_ROLE.SYSTEM)


@shared_task
def maidan_hard_time_out_event(maidan_order_id):
    order = MaidanOrder.objects.get(id=maidan_order_id)
    operator = Person.objects.get(user_id=settings.BOSS)
    if order.status in [ORDER_STATUS.NOT_PAID, ORDER_STATUS.PAYING]:
        order.operate(operator, ORDER_OPERATION_TYPE.CANCEL, ORDER_OPERATION_ROLE.SYSTEM)


@shared_task
def maidan_order_create_event(maidan_order_id):
    maidan_soft_time_out_event.apply_async(
        args=(maidan_order_id,),
        countdown=settings.MAIDAN_SOFT_TIMEOUT
    )

    maidan_hard_time_out_event.apply_async(
        args=(maidan_order_id,),
        countdown=settings.MAIDAN_HARD_TIMEOUT
    )
