# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


def get_objects_from_queryset_and_pk_list(queryset, pk_list):
    qs_objects = queryset.filter(pk__in=pk_list)
    obj_map = {o.pk: o for o in qs_objects}
    return [
        obj_map[pk]
        for pk in pk_list
        if pk in obj_map
    ]


def get_obj_map_from_queryset_and_pk_list(queryset, pk_list):
    qs_objects = queryset.filter(pk__in=pk_list)
    obj_map = {o.pk: o for o in qs_objects}
    return obj_map
