# -*- coding: utf-8 -*-

import logging
import traceback
from .es import tzlc

from gm_types.wiki import TREATMENT_TYPE


def get_ItemWiki(instance):
    try:
        res = dict()

        res['id'] = instance.id
        res['name'] = instance.name.strip()
        res['name_pre'] = instance.name.strip()
        res["other_name"] = instance.other_name.strip()
        res["other_name_pre"] = instance.other_name.strip()
        res['description'] = instance.description
        res['is_online'] = instance.is_online
        res['create_time'] = tzlc(instance.create_time)
        res['effect'] = ''
        res['use_result'] = instance.use_result
        _treatment_method = instance.treatment_method
        res['treatment_method'] = _treatment_method and TREATMENT_TYPE.getDesc(_treatment_method) or ""
        res['association_tags'] = instance.get_item_relation_keywords
        res["tag_not_analyzed"] = instance.get_item_old_tag
        related_product_id_list = instance.get_item_related_product_id()
        res['related_drug'] = instance.get_related_product_id_type_list(related_product_id_list, 0)
        res['related_instrument'] = instance.get_related_product_id_type_list(related_product_id_list, 2)
        res['related_material'] = instance.get_related_product_id_type_list(related_product_id_list, 1)
        res['related_brand'] = []
        res['special'] = ''
        res['ingredient'] = ''
        res['nature_type'] = ''
        res['shape'] = ''
        res['wikitype'] = 0
        res['product_type'] = ''
        res['is_video'] = instance.get_is_video
        res["old_tag_ids"] = instance.get_old_tag_ids()
        return res

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return None


def get_BrandWiki(instance):
    try:
        res = dict()

        res['id'] = instance.id
        res['name'] = instance.name.strip()
        res['name_pre'] = instance.name.strip()
        res["other_name"] = ""
        res["other_name_pre"] = ""
        res['description'] = instance.description
        res['is_online'] = instance.is_online
        res['create_time'] = tzlc(instance.create_time)
        res['effect'] = ''
        res['use_result'] = ''
        res['treatment_method'] = ''
        res['association_tags'] = instance.get_brand_relation_keywords
        res["tag_not_analyzed"] = []
        res['related_drug'] = []
        res['related_instrument'] = []
        res['related_material'] = []
        res['related_brand'] = []
        res['special'] = ''
        res['ingredient'] = ''
        res['nature_type'] = ''
        res['shape'] = ''
        res['wikitype'] = 2
        res['product_type'] = ''
        res['is_video'] = instance.get_is_video
        res['old_tag_ids'] = []
        return res

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return None


def get_CollectWiki(instance):
    try:
        res = dict()

        res['id'] = instance.id
        res['name'] = instance.name.strip()
        res['name_pre'] = instance.name.strip()
        res["other_name"] = ""
        res["other_name_pre"] = ""
        res['description'] = instance.description
        res['is_online'] = instance.is_online
        res['create_time'] = tzlc(instance.create_time)
        res['effect'] = ''
        res['use_result'] = ''
        res['treatment_method'] = ''
        res['association_tags'] = []
        res["tag_not_analyzed"] = instance.get_collect_old_tag
        res['related_drug'] = []
        res['related_instrument'] = []
        res['related_material'] = []
        res['related_brand'] = []
        res['special'] = ''
        res['ingredient'] = ''
        res['nature_type'] = ''
        res['shape'] = ''
        res['wikitype'] = 1
        res['product_type'] = ''
        res['is_video'] = False
        res['old_tag_ids'] = instance.get_old_tag_ids_collect()
        return res

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return None


def get_ProductWiki(instance):
    try:
        res = dict()

        res['id'] = instance.id
        res['name'] = instance.name.strip()
        res['name_pre'] = instance.name.strip()
        res["other_name"] = instance.other_name.strip()
        res["other_name_pre"] = instance.other_name.strip()
        res['description'] = instance.description
        res['is_online'] = instance.is_online
        res['create_time'] = tzlc(instance.create_time)
        res['effect'] = instance.effect
        res['use_result'] = ''
        _treatment_method = instance.treatment_method
        res['treatment_method'] = _treatment_method and TREATMENT_TYPE.getDesc(_treatment_method) or ""
        res['association_tags'] = instance.get_product_relation_keywords
        res["tag_not_analyzed"] = []
        res['related_drug'] = []
        res['related_instrument'] = []
        res['related_material'] = []
        res['related_brand'] = instance.product_brand_info()
        res['special'] = ''
        res['ingredient'] = instance.get_product_params(3)
        res['nature_type'] = instance.get_product_params(4)
        res['shape'] = instance.get_product_params(21)
        res['wikitype'] = 3
        res['product_type'] = ''
        res['is_video'] = instance.get_is_video
        res['old_tag_ids'] = []

        return res

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return None
