#!/usr/bin/env python
# encoding=utf-8

from django.core.management import BaseCommand
from api.models.consult import ConsultScience
from api.models.consult import ConsultScienceWiki

from api.models.consult import ConsultTheme
from api.models.consult import ConsultThemeWiki
from api.models import ItemWiki

class Command(BaseCommand):

    def handle(self, *args, **options):
        #只能执行一次
        delete_data()
        add_data()

def delete_data():
    ConsultScience.objects.all().delete()
    ConsultScienceWiki.objects.all().delete()
    ConsultTheme.objects.all().delete()
    ConsultThemeWiki.objects.all().delete()

data1 = \
[{
    "title": u"闪亮明眸",
    "desc": u"撩汉宝典 必备大眼",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/de3d257600",
    "sub_datas":[{
        "wiki_id":484,
        "slogan":u'毫厘之间 大放睛彩',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/62b37859a6',
    },
    {
        "wiki_id":192,
        "slogan":u'嘘！大眼睛的小秘密',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/f7714d5dbd',
    },
    {
        "wiki_id":194,
        "slogan":u'抚平眼袋 定格年轻双眸',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/43d8e50210',
    },
    {
        "wiki_id":205,
        "slogan":u'告别疲惫 再见熊猫眼',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/d3965a1d96',
    },
    {
        "wiki_id":201,
        "slogan":u'为你点亮媚眼的小心机',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/36bf70877f',
    }]   
},
{
    "title": u"童颜利器",
    "desc": u"女明星逆龄的秘密",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/ab63b39036",
    "sub_datas":[{
        "wiki_id":527,
        "slogan":u'秒变少女萌萌哒',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/209463c376',
    },
    {
        "wiki_id":290,
        "slogan":u'带你年轻 带你飞 ',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/aed4e175be',
    },
    {
        "wiki_id":369,
        "slogan":u'黄脸婆到学生妹的逆袭',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/aaf8e25546',
    },
    {
        "wiki_id":481,
        "slogan":u'逆时光 逆引力 真童颜',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/073fb80f70',
    },
    {
        "wiki_id":493,
        "slogan":u'抗衰除皱一步到位',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/6ff78d9041',
    }]   
},
{
    "title": u"我要笑更美",
    "desc": u"爱笑的人运气都不差",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/d72fbf10aa",
    "sub_datas":[{
        "wiki_id":565,
        "slogan":u'给口腔的大扫除',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/147f860231',
    },
    {
        "wiki_id":265,
        "slogan":u'貌美牙为先  齿白七分俏',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/adcb6a10d0',
    },
    {
        "wiki_id":244,
        "slogan":u'你就是蒙娜丽莎',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/475a8451c7',
    },
    {
        "wiki_id":459,
        "slogan":u'跟钢牙 say byebye~',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/4e998c6d5c',
    },
    {
        "wiki_id":563,
        "slogan":u'牙齿好 颜值又加分',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/68d912a744',
    }]   
},
{
    "title": u"瓷感美肌",
    "desc": u"皮肤俏 不显老",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/8ae3ee1b00",
    "sub_datas":[{
        "wiki_id":429,
        "slogan":u'乔妹同款灯泡肌',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/1ff7b88d76',
    },
    {
        "wiki_id":433,
        "slogan":u'肌肤焕发光彩 绽放青春美白',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/45756af691',
    },
    {
        "wiki_id":533,
        "slogan":u'厚角质bye  好肤质来!',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/5664a7b7ad',
    },
    {
        "wiki_id":295,
        "slogan":u'反转肌龄 脸蛋净白嫩',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/9b1bf5515a',
    },
    {
        "wiki_id":501,
        "slogan":u'一次为肌肤喝饱水',
        "image":u'http://hera.s.gengmei.cc/2016/05/12/9b63a9a3e6',
    }]   
}]

data2=\
[{
    "desc": u"pk掉同龄人的必杀器",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/1d6d9c9a18",
    "wiki_id": 480,
    "wiki_ids":[430,481,550]
},
{
    "desc": u"轻松get小V脸",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/d2183e3a70",
    "wiki_id": 498,
    "wiki_ids":[419,227,420]
},
{
    "desc": u"跟黄脸婆、村姑脸说拜拜",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/da6b715939",
    "wiki_id": 302,
    "wiki_ids":[429,295,501]
},
{
    "desc": u"一次治疗 即刻重获青春",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/ddca369359",
    "wiki_id": 503,
    "wiki_ids":[481,551,312]
},
{
    "desc": u"永远不脱妆 专治懒癌",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/61f300742d",
    "wiki_id": 486,
    "wiki_ids":[591,594]
},
{
    "desc": u"让你的肌肤自带磨皮感",
    "image": u"http://hera.s.gengmei.cc/2016/05/12/1dc3548a44",
    "wiki_id": 432,
    "wiki_ids":[501,433,383]
}]

def add_data():
    script1(data1)
    script2(data2)

def script1(datas):
    for data in datas:
        theme = ConsultTheme()
        theme.title = data['title']
        theme.desc = data['desc']
        theme.image = data['image']
        theme.save()

        sub_datas = data['sub_datas']

        for sub_data in sub_datas:
            theme_wiki = ConsultThemeWiki()
            theme_wiki.consult_theme = theme
            theme_wiki.image = sub_data['image']
            theme_wiki.slogan = sub_data['slogan']

            try:
                wiki = ItemWiki.objects.get(id = sub_data['wiki_id'])

                theme_wiki.wiki = wiki
                theme_wiki.save()
            except:
                pass

def script2(datas):
    for data in datas:
        science = ConsultScience()
        science.desc = data['desc']
        science.image = data['image']

        try:
            wiki = ItemWiki.objects.get(id = data['wiki_id'])

            science.wiki = wiki
            science.save()
            wiki_ids = data['wiki_ids']

            for wiki_id in wiki_ids:
                science_wiki = ConsultScienceWiki()
                science_wiki.consult_science = science

                try:
                    wiki = ItemWiki.objects.get(id = wiki_id)

                    science_wiki.wiki = wiki
                    science_wiki.save()
                except:
                    pass
        except:
            pass
