# coding:utf-8
from __future__ import absolute_import, unicode_literals
from django.db import models
from django.contrib.auth.models import User
from gm_types.gaia import USER_HOME_TYPE


class UserHomePage(models.Model):

    class Meta:
        verbose_name = u'首页版本设置'
        verbose_name_plural = u'首页版本设置'
        db_table = 'api_user_home_page'
        app_label = 'api'

    user = models.ForeignKey(User, verbose_name=u'用户', unique=True, related_name='home_page_version')
    home_page = models.IntegerField(choices=USER_HOME_TYPE, verbose_name=u"首页设置", help_text=u"0为老首页，1为新首页")