# -*- coding: utf-8 -*-
# @Time    : 2019/5/7 2:38 PM
# @Author  : Esse
# @FileName: tag.py

from gm_types.gaia import TAG_TYPE, RECOMMEND_TYPE
from api.models.tag import Tag
from rpc.decorators import bind, cache_page
from api.manager.tag_manager import get_bodypart_tags

TYPE_LIST = [TAG_TYPE.BODY_PART, TAG_TYPE.BODY_PART_SUB_ITEM, TAG_TYPE.ITEM_WIKI, TAG_TYPE.YUNYING]


@bind('doctor/article/tags')
@cache_page(7200)
def article_tag_list():
    tags = get_bodypart_tags(with_level_3=True)
    yunying_tags = Tag.objects.filter(is_online=True, tag_type=TAG_TYPE.YUNYING)
    article_tags = Tag.objects.filter(is_online=True, recommend_type=RECOMMEND_TYPE.RECOMMENDED_TRACTATE
                                      ).exclude(tag_type__in=TYPE_LIST)
    tags.extend([{
        'tag_id': t.id,
        'tag_name': t.name,
        'sub_tags': []
    } for t in yunying_tags])

    tags.extend([{
        'tag_id': t.id,
        'tag_name': t.name,
        'sub_tags': []
    }] for t in article_tags)
    return tags


