-- dependson: None
-- model: api.models.Feedback, api.models.FeedbackCategory, api.models.FeedbackImage
-- author: Pengfei.X
-- date: 2015.09.1 18:46:00
-- description: add table api_feedbackcategory, alter table api_feedback, add table api_feedbackimages


CREATE TABLE api_feedbackcategory (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `description` varchar(256) NOT NULL,
  `position` int(11) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `related_type` varchar(1) DEFAULT NULL,
  `icon` varchar(120) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


ALTER TABLE api_feedback ADD COLUMN `related_id` int(11) DEFAULT NULL;
ALTER TABLE api_feedback ADD COLUMN `who_id` int(11) DEFAULT NULL;
ALTER TABLE api_feedback ADD COLUMN `feedbackcategory_id` int(11) DEFAULT NULL;
ALTER TABLE api_feedback ADD CONSTRAINT `fk_feedback_user_by_who` FOREIGN KEY (`who_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE api_feedback ADD CONSTRAINT `fk_feedbackcategory_feedback` FOREIGN KEY (`feedbackcategory_id`) REFERENCES `api_feedbackcategory` (`id`);
ALTER TABLE api_feedback ADD COLUMN `last_modified` datetime NOT NULL;


CREATE TABLE `api_feedbackimage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feedback_id` int(11) NOT NULL,
  `image_url` varchar(300) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_feedback_image_feedback_id` FOREIGN KEY (`feedback_id`) REFERENCES `api_feedback` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=265062 DEFAULT CHARSET=utf8;
