# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from talos.services.models.base import ServiceModelBase
from talos.backbone.rpc import RPCMixin


class Hospital(RPCMixin, ServiceModelBase):

    __slots__ = [
        'id',
        'name',
        'city_tag_id',
        'province_tag_id',
        'country_tag_id',
    ]

    _auto_type_map_ = [
        ('name', unicode, u''),
        ('city_tag_id', int, None),
        ('province_tag_id', int, None),
        ('country_tag_id', int, None),
    ]

    def __init__(self, id, name, city_tag_id=None, province_tag_id=None, country_tag_id=None):
        self.id = id
        self.name = name
        self.city_tag_id = city_tag_id
        self.province_tag_id = province_tag_id
        self.country_tag_id = country_tag_id

    def __bool__(self):
        return self.id is not None

    __nonzero__ = __bool__
