# coding=utf-8
from django.core.management import BaseCommand

from answer.models import Answer, Question, UserAnswerQuestion


class Command(BaseCommand):
    """
    同步线上question/answer两张表的数据进user_question_answer表
    """

    def handle(self, *args, **options):
        for answer in Answer.objects.filter(user_id__isnull=False, is_online=True):
            UserAnswerQuestion.objects.update_or_create(user=answer.user, answer=answer, create_time=answer.create_time)

        for question in Question.objects.filter(user_id__isnull=False, is_online=True):
            UserAnswerQuestion.objects.update_or_create(user=question.user, question=question, create_time=question.create_time)

