-- Deploy gaia:2017_07_03_add_pos_machine to mysql

BEGIN;

CREATE TABLE `api_posmachine` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `code` varchar(64) UNIQUE,
    `update_time` datetime(6) NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_posmachine` ADD CONSTRAINT `doctor_id_refs_id_35df95b0` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE INDEX `api_posmachine_72821be1` ON `api_posmachine` (`doctor_id`);

CREATE TABLE `api_posrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `pay_code` varchar(100) NOT NULL,
    `doctor_id` varchar(100) NOT NULL,
    `amount` double precision NOT NULL,
    `record_time` datetime(6) NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_posrecord` ADD CONSTRAINT `doctor_id_refs_id_268caa39` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE INDEX `api_posrecord_72821be1` ON `api_posrecord` (`doctor_id`);
CREATE INDEX `api_posrecord_810452e1` ON `api_posrecord` (`record_time`);


CREATE TABLE `api_posrecord_sum` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `day` date NOT NULL,
    `amount` double precision NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_posrecord_sum` ADD CONSTRAINT `doctor_id_refs_id_74e0b70d` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE INDEX `api_posrecord_sum_72821be1` ON `api_posrecord_sum` (`doctor_id`);

ALTER TABLE `pay_statement` ADD COLUMN `pos_back` double precision(16,2) NOT NULL DEFAULT 0.00;
ALTER TABLE `pay_statement` ADD COLUMN `sub_data` text NOT NULL DEFAULT '';


COMMIT;
