# -*- coding: utf-8 -*-
from __future__ import absolute_import

from difflib import SequenceMatcher


def fmatch_iter(needle, haystack, min_ratio=None):
    for key in haystack:
        ratio = SequenceMatcher(None, needle, key).ratio()
        if ratio >= min_ratio:
            yield ratio, key
        else:
            yield ratio, key


def fmatch_best(needle, haystack, min_ratio=0.6):
    try:
        return sorted(
            fmatch_iter(needle, haystack, min_ratio), reverse=True,
        )[0][1]
    except IndexError:
        pass


def fmath_all(needle, haystack, min_ratio=0.6):

    return all([ratio > min_ratio for ratio, _ in fmatch_iter(needle, haystack)])
