#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function

from gm_types.gaia import VIDEO_LIBRARY_VIDEO_TYPE

from rpc.decorators import bind
from wiki.models.video import VideoLibrary


@bind("api/get_video_list_by_source_id")
def get_video_library_info(source_id, video_type):
    """
    获取
    :param source_id:  关联id
    :param video_type: 视频类型
    :return:
    """
    assert video_type in VIDEO_LIBRARY_VIDEO_TYPE
    result = {
        "video_list": []
    }
    if not source_id:
        return result

    video_list = VideoLibrary.objects.filter(
        source_id=source_id, video_type=video_type, is_online=True).order_by("ordering", "-id")
    result["video_list"] = [video.get_video_info() for video in video_list]

    return result
