# -*- coding: utf-8 -*-

import json
from rpc.cache import itemwiki_hot_cache
from api.models import ItemWiki


class ItemwikiHot(object):
    """百科热门配置
    """

    rkey = 'hots'  # redis key

    @classmethod
    def get(cls):
        try:
            hots_json = itemwiki_hot_cache.get(cls.rkey)
            hots = json.loads(hots_json)
        except:
            hots = []
        return hots

    @classmethod
    def get_objs(cls):
        hot_ids = cls.get()
        hot_objs = ItemWiki.objects.filter(id__in=hot_ids)
        return hot_objs

    @classmethod
    def set(cls, hot_ids):
        itemwiki_hot_cache.set(cls.rkey, json.dumps(hot_ids))
