# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

import datetime
import multiprocessing

from celery import shared_task

from doris.models.service import ServiceStat
from trans2es.management.commands.trans2es_data2es_parallel import Command


def _delete_old_doris_data():
    delete_date = (datetime.datetime.now() - datetime.timedelta(days=3)).strftime('%Y%m%d')
    ServiceStat.objects.filter(stat_date=delete_date).delete()


@shared_task
def doris_trans2es():
    command = Command()
    command.handle(
            index_prefix=None,
            settings=None,
            pythonpath=None,
            verbosity='1',
            traceback=None,
            type_list=['service'],
            no_color=False,
            streaming_slicing=True,
            parallel=multiprocessing.cpu_count(),
    )
    _delete_old_doris_data()
