from django.core.management import BaseCommand

from talos.cache.base import talos_rpc_service_model_cache
from talos.services.base import RpcServiceModelCache
from talos.services.user import UserService


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        c = RpcServiceModelCache(talos_rpc_service_model_cache, 'user')
        keys = c._get_cached_keys()
        step = 50

        for i in xrange((len(keys) / step)+1):
            _ks = keys[i*step: (i+1)*step]
            ids = []
            for _k in _ks:
                if _k:
                    ids.append(_k.split(':')[-1])

            UserService.get_users_by_user_ids(ids)

        print 'Done!'
