# coding: utf-8

from django.db import models

from rpc.tool.dict_mixin import to_dict
from api.basemodel import RequestSourceModel
from api.tool.datetime_tool import get_timestamp_or_none
from .tag import Tag
from .special import Special
from .service import Service
from .area import Province, City, Region

# TODO zhangyunyu 看起来都是调用的to_dict
# from .diary import Diary
# from .topic import Problem
# from .activity import Activity

from gm_upload import IMG_TYPE, ImgUrlField
from gm_types.gaia import POPUPAD_USER_TYPE, SLIDE_USER_TYPE, SLIDE_PAYMENT_TYPE


class GreetingPopup(RequestSourceModel):
    PageType = (
        ('0', u'开屏页'),
        ('1', u'首页提醒'),
    )

    class Meta:
        verbose_name = u'开屏页和首页提醒'
        app_label = 'api'
        db_table = 'api_greetingpopup'

    title = models.CharField(verbose_name=u'名称', max_length=100)
    image = ImgUrlField(img_type=IMG_TYPE.GREETINGPOPUP, verbose_name=u'图片地址', max_length=256)
    image_ipx = ImgUrlField(img_type=IMG_TYPE.GREETINGPOPUP, verbose_name=u'iphoneX图片地址', max_length=256)
    type = models.CharField(verbose_name=u'类型(区分开屏页面和首页弹窗)',
                            max_length=2, choices=PageType)
    url = models.CharField(verbose_name=u'不走协议的跳转url(网页、邀请好友页等)',
                           max_length=256, null=True, blank=True, default='')
    start_time = models.DateTimeField(verbose_name=u'开始时间')
    end_time = models.DateTimeField(verbose_name=u'结束时间')
    is_online = models.BooleanField(verbose_name=u'是否在线', default=False)
    topic_id = models.IntegerField(verbose_name=u'指定的话题', null=True, blank=True)
    diary_id = models.IntegerField(verbose_name=u'指定的日记',
                              null=True, blank=True)
    special = models.ForeignKey(Special, verbose_name=u'指定的福利专题',
                                null=True, blank=True)
    service = models.ForeignKey(Service, verbose_name=u'指定的服务',
                                null=True, blank=True)
    tag = models.ForeignKey(Tag, verbose_name=u'指定的Tag列表',
                            null=True, blank=True)
    activity_id = models.IntegerField(verbose_name=u'免费活动',
                                 null=True, blank=True)
    rank = models.IntegerField(verbose_name=u'排序', default=999999)
    is_sustain = models.BooleanField(verbose_name=u'是否持续展示', default=False)
    popup_user_type = models.IntegerField(verbose_name=u'弹窗广告用户类型', choices=POPUPAD_USER_TYPE,
                                          default=POPUPAD_USER_TYPE.ALL)
    payment_type = models.CharField(max_length=2, choices=SLIDE_PAYMENT_TYPE, default=SLIDE_PAYMENT_TYPE.ALL_PAYMENT)
    channels = models.CharField(max_length=512, null=True, blank=True, verbose_name=u'渠道号')

    regions = models.ManyToManyField(Region, verbose_name=u'展示大区')
    cities = models.ManyToManyField(City, verbose_name=u'展示城市')
    aggregation_id = models.IntegerField(verbose_name=u"新专题聚合id", null=True, blank=True)

    def to_dict(self):
        data = to_dict(
            self,
            fields=[
                'id', 'title', 'image', 'image_ipx', 'url', 'topic_id', 'diary_id',
                'special_id', 'service_id', 'tag_id', 'activity_id', 'aggregation_id'
            ]
        )
        data['start_time'] = get_timestamp_or_none(self.start_time)
        data['end_time'] = get_timestamp_or_none(self.end_time)

        return data
