# -*- coding: utf8 -*-

import math
import datetime
import time
import hashlib

from api.models.types import PLATFORM_CHANNEL


def check_platform(platform):
    """
    NOTE:
        新建person时，保存platform
        :param platform:
        :return:
        change log: version5.7
    """
    if not platform:
        return PLATFORM_CHANNEL.UNKNOWN

    if platform in [PLATFORM_CHANNEL.UNKNOWN,
                    PLATFORM_CHANNEL.IOS, PLATFORM_CHANNEL.ANDROID,
                    PLATFORM_CHANNEL.M, PLATFORM_CHANNEL.PC, PLATFORM_CHANNEL.WECHAT_APP, PLATFORM_CHANNEL.MOMO]:
        return platform

    platform = platform.lower()
    if platform == 'iphone':
        return PLATFORM_CHANNEL.IOS

    if platform == 'android':
        return PLATFORM_CHANNEL.ANDROID

    if platform == 'xcx':
        return PLATFORM_CHANNEL.WECHAT_APP

    return PLATFORM_CHANNEL.UNKNOWN


def number_floor(result, number):
    """
    NOTE:
        返回截取小数点后number位的数
    """
    multiple_num = math.pow(10, number)
    tmp_result = result * multiple_num
    result = math.floor(tmp_result) / multiple_num
    return result


def upload_name(ext=None):
    prefix = datetime.datetime.today().strftime("%Y/%m/%d")
    md5 = hashlib.md5(str(time.time())).hexdigest()[:10]
    md5 = prefix + '/' + md5
    if ext is not None:
        md5 = md5 + '.' + ext
    return unicode(md5)