#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/1/15


from django.core.management import BaseCommand
from facialactivity.models import ActivityConfig
from gm_types.gaia import NEW_SPRING_ACTIVITY_IMA_LEVEL


def bulk_create_data():
    bulk_create_list = []
    print('---------------traverse start----------------')
    for level in range(1, 10):
        tag = NEW_SPRING_ACTIVITY_IMA_LEVEL.getDesc(level)
        bulk_create_list.append(ActivityConfig(level=level, tag=tag))
    print('---------------traverse end----------------')
    ActivityConfig.objects.bulk_create(bulk_create_list)


class Command(BaseCommand):
    def handle(self, *args, **options):
        print('---------------bulk create start---------')
        bulk_create_data()
        print('---------------bulk create end---------')