# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import ShortMessageSend


class ShortMessageSendDB(DataBuilder):

    def getval_send_status(self, obj, default=''):
        return u'已经发送' if obj.send_status else u'未发送'

    def getval_send_time(self, obj, default=''):
        return str(obj.send_time).split('.')[0] if obj.send_status else ''


@DB
class ShortMessageSendDQ(DataSQLQuery):
        model = ShortMessageSend
        data_model = ShortMessageSendDB
