# coding=utf-8
from django.core.management import BaseCommand
from gm_types.gaia import DOCTOR_SECKILL_APPLY_STATUS
from api.models import DoctorSeckillApply
import math


class Command(BaseCommand):

    def handle(self, *args, **options):
        applys = DoctorSeckillApply.objects.all()
        for apply in applys.iterator():
            try:
                apply.status = DOCTOR_SECKILL_APPLY_STATUS.PASS
                apply.pre_payment_price = math.ceil(apply.seckill_price * 0.2)
                apply.commission = math.ceil(apply.seckill_price * 0.1)
                apply.save()
                print apply.id
            except Exception as e:
                print e.message
                continue
        print u'Done'
