# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.db.models import CharField, TextField, DateTimeField, BooleanField
from api.models.wikitag import BrandTag, WordRel_wiki, Wiki_wordrelsynonym
from wiki.models.video import VideoLibrary

import logging
import traceback
import datetime


class BrandWiki(models.Model):
    class Meta:
        verbose_name = u'品牌'
        db_table = 'wiki_brand'

    id = models.IntegerField(verbose_name=u'品牌ID', primary_key=True)
    name = CharField(u'项目介绍', max_length=48)
    description = TextField(u'品牌简介')
    is_online = BooleanField(u'是否上线', default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))

    def get_brand_tag_id_type(self):

        try:
            association_tags_id_list = list()

            query_results = BrandTag.objects.filter(brand_id=self.id)

            for item in query_results:
                association_tags_id_list.append({"is_effect": item.is_effect, "tag_id": item.wordrel_id})

            logging.info("get_brand_tag_id_type:%s" % association_tags_id_list)

            return association_tags_id_list

        except:

            logging.error("catch exception,err_msg:%s" % traceback.format_exc())

            return []

    def get_brand_keyword_id(self, association_tags_id_list):

        try:
            association_tags_list = list()

            for tags in association_tags_id_list:

                logging.info("ididid:%s" % association_tags_id_list)

                query_results = WordRel_wiki.objects.filter(id=tags.get('tag_id'))

                for items in query_results:
                    association_tags_list.append([items.id, items.keyword, tags.get('is_effect')])

            logging.info("get_brand_keyword_id:%s" % association_tags_id_list)

            return association_tags_list

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    def get_brand_keyword(self, association_tags_list):

        try:
            association_keywords_list = list()

            for item in association_tags_list:

                logging.info("ididid:%s" % association_tags_list)

                query_results = set(Wiki_wordrelsynonym.objects.filter(wordrel_id=item[0]).values_list("word", flat=True))
                if item[2]:
                    query_results.add(item[1])
                    association_keywords_list.extend(list(query_results))

            logging.info("get_brand_keyword_id:%s" % association_keywords_list)

            return association_keywords_list

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @property
    def get_brand_relation_keywords(self):
        association_keywords_set = set()
        # 先找关联的所有有效的词根id
        association_tags_id_list = list(BrandTag.objects.filter(
            brand_id=self.id, is_effect=True).values_list("wordrel_id", flat=True))

        # 找这些词根的词
        word_root_list = list(WordRel_wiki.objects.filter(
            id__in=association_tags_id_list).values_list("keyword", flat=True))

        # 找词根关联的所有同义词
        query_synonym_list = list(Wiki_wordrelsynonym.objects.filter(
            wordrel_id__in=association_tags_id_list).values_list("word", flat=True))

        association_keywords_set.update(word_root_list)
        association_keywords_set.update(query_synonym_list)

        return list(association_keywords_set)

    @property
    def get_is_video(self):
        """
        判断该百科是否有视频
        :return:
        """
        try:
            bol = VideoLibrary.objects.filter(source_id=self.id, video_type=1)
            if len(bol):
                return True
            else:
                return False
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())

