# -*- coding: UTF-8 -*-

from ..base.trigger import TriggerBase
from gm_dbmw_api.descriptor.source import MySQLTableSource, RelatedSource, GroupedSource, MySQLTableScanSource
from gm_dbmw_api.descriptor.relation import MySQLTableRelation
from django.conf import settings

_DTMAP = settings.DB_TABLE_MAP


class DiaryTrigger(TriggerBase):
    name = 'diaryvm'
    vmcls_name = 'DiaryVM'

    @classmethod
    def full_source(cls):
        return MySQLTableScanSource(
            logical_database_id=_DTMAP['api_diary']['db'],
            table_name=_DTMAP['api_diary']['table'],
            key_columns=['id'],
            reversed_scanning=True,  # 倒序扫描
            cyclic=False,  # 循环scan
            # scan_rate=8,  # 每秒处理个数？
        )

    @classmethod
    def scan_source(cls):
        return MySQLTableScanSource(
            logical_database_id=_DTMAP['api_diary']['db'],
            table_name=_DTMAP['api_diary']['table'],
            key_columns=['id'],
            reversed_scanning=True,  # 倒序扫描
            cyclic=True,  # 循环scan
            scan_rate=8,  # 每秒处理个数？
        )

    @classmethod
    def trigger_source(cls):
        return GroupedSource.of(
            MySQLTableSource(
                logical_database_id=_DTMAP['api_diary']['db'],
                table_name=_DTMAP['api_diary']['table'],
                key_columns=['id'],
            ),
            RelatedSource(
                source=MySQLTableSource(
                    logical_database_id=_DTMAP['auth_user']['db'],
                    table_name=_DTMAP['auth_user']['table'],
                    key_columns=['id'],
                    value_columns=['last_name'],
                ),
                relation=MySQLTableRelation(
                    logical_database_id=_DTMAP['api_diary']['db'],
                    table_name=_DTMAP['api_diary']['table'],
                    from_columns=['user_id'],
                    to_columns=['id'],
                ),
            ),
            RelatedSource(
                source=MySQLTableSource(
                    logical_database_id=_DTMAP['api_doctor']['db'],
                    table_name=_DTMAP['api_doctor']['table'],
                    key_columns=['id'],
                    value_columns=['name'],
                ),
                relation=MySQLTableRelation(
                    logical_database_id=_DTMAP['api_diary']['db'],
                    table_name=_DTMAP['api_diary']['table'],
                    from_columns=['doctor_id'],
                    to_columns=['id'],
                ),
            ),
            RelatedSource(
                source=MySQLTableSource(
                    logical_database_id=_DTMAP['api_hospital']['db'],
                    table_name=_DTMAP['api_hospital']['table'],
                    key_columns=['id'],
                    value_columns=['name'],
                ),
                relation=MySQLTableRelation(
                    logical_database_id=_DTMAP['api_diary']['db'],
                    table_name=_DTMAP['api_diary']['table'],
                    from_columns=['hospital_id'],
                    to_columns=['id'],
                ),
            ),
            RelatedSource(
                source=MySQLTableSource(
                    logical_database_id=_DTMAP['api_order']['db'],
                    table_name=_DTMAP['api_order']['table'],
                    key_columns=['id'],
                    value_columns=['is_self', 'status', 'cash_back_status'],
                ),
                relation=MySQLTableRelation(
                    logical_database_id=_DTMAP['api_diary']['db'],
                    table_name=_DTMAP['api_diary']['table'],
                    from_columns=['order_id'],
                    to_columns=['id'],
                ),
            ),
            RelatedSource(
                source=MySQLTableSource(
                    logical_database_id=_DTMAP['api_service']['db'],
                    table_name=_DTMAP['api_service']['table'],
                    key_columns=['id'],
                    value_columns=['name', 'is_online'],
                ),
                relation=MySQLTableRelation(
                    logical_database_id=_DTMAP['api_diary']['db'],
                    table_name=_DTMAP['api_diary']['table'],
                    from_columns=['service_id'],
                    to_columns=['id'],
                ),
            ),
            MySQLTableSource(
                logical_database_id=_DTMAP['api_problem']['db'],
                table_name=_DTMAP['api_problem']['table'],
                key_columns=['diary_id'],
            ),
            MySQLTableSource(
                logical_database_id=_DTMAP['api_diary_tags']['db'],
                table_name=_DTMAP['api_diary_tags']['table'],
                key_columns=['diary_id'],
            ),

        )
