-- Deploy gaia:2017_10_26_user_report_doctor to mysql

BEGIN;

CREATE TABLE `api_reportdoctor` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `service_id` integer,
    `doctor_id` varchar(100),
    `hospital_id` varchar(100),
    `comment` varchar(300) NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_reportdoctor` ADD CONSTRAINT `hospital_id_refs_id_28f0f801` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);
ALTER TABLE `api_reportdoctor` ADD CONSTRAINT `user_id_refs_id_84f7fb1c` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_reportdoctor` ADD CONSTRAINT `service_id_refs_id_3371d64e` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `api_reportdoctor` ADD CONSTRAINT `doctor_id_refs_id_7596d4f8` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `api_reportimages` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `report_id` integer NOT NULL,
    `image` varchar(100) NOT NULL
)
;
ALTER TABLE `api_reportimages` ADD CONSTRAINT `report_id_refs_id_c02209ee` FOREIGN KEY (`report_id`) REFERENCES `api_reportdoctor` (`id`);
CREATE INDEX `api_reportdoctor_6340c63c` ON `api_reportdoctor` (`user_id`);
CREATE INDEX `api_reportdoctor_91a0ac17` ON `api_reportdoctor` (`service_id`);
CREATE INDEX `api_reportdoctor_72821be1` ON `api_reportdoctor` (`doctor_id`);
CREATE INDEX `api_reportdoctor_3113e40b` ON `api_reportdoctor` (`hospital_id`);
CREATE INDEX `api_reportimages_ae85b46e` ON `api_reportimages` (`report_id`);

COMMIT;
