# coding=utf-8
from django.db import models
from django.db.models import BooleanField, IntegerField
from django.db.models import TextField, CharField, DateTimeField, ForeignKey

manager = lambda: models.Manager().db_manager(using='verita')


class WeChatRoomConfig(models.Model):
    class Meta:
        db_table = 'api_wechat_room_config'
        app_label = 'verita'
    objects = manager()

    name = CharField('名称', max_length=20)
    notice = TextField('入群须知')
    enroll = TextField('报名方式')
    transfer = TextField('中转页文案')
    poster = CharField('海报', max_length=256)
    auto_reply = TextField('审核话术')
    forbidden_word = TextField('违禁词')
    forbidden_warning = TextField('违禁提示')
    create_time = DateTimeField(auto_now_add=True, db_index=True)
    update_time = DateTimeField(auto_now=True, db_index=True)


class WechatRoom(models.Model):
    class Meta:
        db_table = 'api_wechat_room'
        app_label = 'verita'
    objects = manager()

    room_name = CharField('房间名', max_length=100)
    room_type = ForeignKey(WeChatRoomConfig)
    person_num = IntegerField('人数', default=0)
    qrcode = CharField('群二维码', max_length=256)
    create_time = DateTimeField(auto_now_add=True, db_index=True)
    update_time = DateTimeField(auto_now=True, db_index=True)


class FriendInvite(models.Model):
    class Meta:
        db_table = 'api_friend_invite'
        app_label = 'verita'
    objects = manager()

    user_name = CharField('用户昵称', max_length=100)
    room = ForeignKey(WechatRoom, verbose_name='房间id')
    invite_name = CharField('邀请用户昵称', max_length=100)
    create_time = DateTimeField(auto_now_add=True, db_index=True)
    update_time = DateTimeField(auto_now=True, db_index=True)


class UserInfo(models.Model):
    class Meta:
        db_table = 'api_user_info'
        app_label = 'verita'
    objects = manager()

    user_name = CharField('用户昵称', max_length=100)
    room = ForeignKey(WechatRoom, verbose_name='房间id')
    error_num = IntegerField('违规次数', default=0)
    create_time = DateTimeField(auto_now_add=True, db_index=True)
    update_time = DateTimeField(auto_now=True, db_index=True)


class InteractiveWord(models.Model):
    class Meta:
        db_table = 'api_interactiveword'
        app_label = 'verita'
    objects = manager()

    room = ForeignKey(WeChatRoomConfig)
    word = CharField('互动关键词', max_length=100)
    replay = CharField('回复', max_length=200)
    enable = BooleanField(default=True)
    create_time = DateTimeField(auto_now_add=True, db_index=True)
    update_time = DateTimeField(auto_now=True, db_index=True)
