-- Deploy gaia:gaia_2019_04_08_add_homepage_icon_table to mysql

BEGIN;

CREATE TABLE `api_homepageicon_regions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `homepageicon_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    UNIQUE (`homepageicon_id`, `region_id`)
)
;
ALTER TABLE `api_homepageicon_regions` ADD CONSTRAINT `region_id_refs_id_a1bc8f73` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
CREATE TABLE `api_homepageicon_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `homepageicon_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`homepageicon_id`, `city_id`)
)
;
ALTER TABLE `api_homepageicon_cities` ADD CONSTRAINT `city_id_refs_id_d572136f` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_homepageicon` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(16) NOT NULL,
    `image` varchar(1024),
    `jump_type` varchar(2) NOT NULL,
    `jump` varchar(1024),
    `service_type` varchar(2) NOT NULL,
    `rank` integer NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `last_time` datetime(6),
    `last_operator_id` integer NOT NULL
)
;
ALTER TABLE `api_homepageicon` ADD CONSTRAINT `last_operator_id_refs_id_09ee1cb7` FOREIGN KEY (`last_operator_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_homepageicon_regions` ADD CONSTRAINT `homepageicon_id_refs_id_0db52873` FOREIGN KEY (`homepageicon_id`) REFERENCES `api_homepageicon` (`id`);
ALTER TABLE `api_homepageicon_cities` ADD CONSTRAINT `homepageicon_id_refs_id_0a391f66` FOREIGN KEY (`homepageicon_id`) REFERENCES `api_homepageicon` (`id`);
CREATE TABLE `api_festival_homepage_icon_regions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `festivalhomepageicon_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    UNIQUE (`festivalhomepageicon_id`, `region_id`)
)
;
ALTER TABLE `api_festival_homepage_icon_regions` ADD CONSTRAINT `region_id_refs_id_4e543771` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
CREATE TABLE `api_festival_homepage_icon_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `festivalhomepageicon_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`festivalhomepageicon_id`, `city_id`)
)
;
ALTER TABLE `api_festival_homepage_icon_cities` ADD CONSTRAINT `city_id_refs_id_5c1dc6b4` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_festival_homepage_icon` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(32) NOT NULL,
    `font_color` varchar(2) NOT NULL,
    `background_image` varchar(1024),
    `image1` varchar(1024),
    `image2` varchar(1024),
    `image3` varchar(1024),
    `image4` varchar(1024),
    `image5` varchar(1024),
    `image6` varchar(1024),
    `image7` varchar(1024),
    `image8` varchar(1024),
    `image9` varchar(1024),
    `image10` varchar(1024),
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `last_time` datetime(6),
    `last_operator_id` integer NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_festival_homepage_icon` ADD CONSTRAINT `last_operator_id_refs_id_e8285a79` FOREIGN KEY (`last_operator_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_festival_homepage_icon_regions` ADD CONSTRAINT `festivalhomepageicon_id_refs_id_786652e5` FOREIGN KEY (`festivalhomepageicon_id`) REFERENCES `api_festival_homepage_icon` (`id`);
ALTER TABLE `api_festival_homepage_icon_cities` ADD CONSTRAINT `festivalhomepageicon_id_refs_id_8021985e` FOREIGN KEY (`festivalhomepageicon_id`) REFERENCES `api_festival_homepage_icon` (`id`);
CREATE TABLE `api_homepageactivity_regions` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `homepageactivity_id` integer NOT NULL,
    `region_id` integer NOT NULL,
    UNIQUE (`homepageactivity_id`, `region_id`)
)
;
ALTER TABLE `api_homepageactivity_regions` ADD CONSTRAINT `region_id_refs_id_29831430` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);
CREATE TABLE `api_homepageactivity_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `homepageactivity_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`homepageactivity_id`, `city_id`)
)
;
ALTER TABLE `api_homepageactivity_cities` ADD CONSTRAINT `city_id_refs_id_aca301fb` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
CREATE TABLE `api_homepageactivity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(16) NOT NULL,
    `image` varchar(1024),
    `jump_type` varchar(2) NOT NULL,
    `jump` varchar(1024),
    `service_type` varchar(2) NOT NULL,
    `location` varchar(2) NOT NULL,
    `user_type` varchar(2) NOT NULL,
    `payment_type` varchar(2) NOT NULL,
    `is_online` bool NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `last_time` datetime(6),
    `last_operator_id` integer NOT NULL
)
;
ALTER TABLE `api_homepageactivity` ADD CONSTRAINT `last_operator_id_refs_id_29d8ed56` FOREIGN KEY (`last_operator_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_homepageactivity_regions` ADD CONSTRAINT `homepageactivity_id_refs_id_8475ac43` FOREIGN KEY (`homepageactivity_id`) REFERENCES `api_homepageactivity` (`id`);
ALTER TABLE `api_homepageactivity_cities` ADD CONSTRAINT `homepageactivity_id_refs_id_aa29bc61` FOREIGN KEY (`homepageactivity_id`) REFERENCES `api_homepageactivity` (`id`);


CREATE INDEX `api_homepageicon_regions_933a44bb` ON `api_homepageicon_regions` (`homepageicon_id`);
CREATE INDEX `api_homepageicon_regions_55a4ce96` ON `api_homepageicon_regions` (`region_id`);
CREATE INDEX `api_homepageicon_cities_933a44bb` ON `api_homepageicon_cities` (`homepageicon_id`);
CREATE INDEX `api_homepageicon_cities_b376980e` ON `api_homepageicon_cities` (`city_id`);
CREATE INDEX `api_homepageicon_ab1bcae8` ON `api_homepageicon` (`last_operator_id`);
CREATE INDEX `api_festival_homepage_icon_regions_c6fca214` ON `api_festival_homepage_icon_regions` (`festivalhomepageicon_id`);
CREATE INDEX `api_festival_homepage_icon_regions_55a4ce96` ON `api_festival_homepage_icon_regions` (`region_id`);
CREATE INDEX `api_festival_homepage_icon_cities_c6fca214` ON `api_festival_homepage_icon_cities` (`festivalhomepageicon_id`);
CREATE INDEX `api_festival_homepage_icon_cities_b376980e` ON `api_festival_homepage_icon_cities` (`city_id`);
CREATE INDEX `api_festival_homepage_icon_ab1bcae8` ON `api_festival_homepage_icon` (`last_operator_id`);
CREATE INDEX `api_homepageactivity_regions_91fd967b` ON `api_homepageactivity_regions` (`homepageactivity_id`);
CREATE INDEX `api_homepageactivity_regions_55a4ce96` ON `api_homepageactivity_regions` (`region_id`);
CREATE INDEX `api_homepageactivity_cities_91fd967b` ON `api_homepageactivity_cities` (`homepageactivity_id`);
CREATE INDEX `api_homepageactivity_cities_b376980e` ON `api_homepageactivity_cities` (`city_id`);
CREATE INDEX `api_homepageactivity_ab1bcae8` ON `api_homepageactivity` (`last_operator_id`);

COMMIT;
