# coding=utf-8

from django.core.management import BaseCommand

from talos.models.topic import Problem, TopicImage
from gm_types.gaia import TOPIC_TYPE

# 旧数据中，专栏文章的图片没有设置为is_cover=True


class Command(BaseCommand):
    def handle(self, *args, **options):
        _max_num = 100
        all_articles = Problem.objects.filter(topic_type=TOPIC_TYPE.COLUMN_ARTICLE)
        articles, index = all_articles[:_max_num], 0
        while articles:
            for article in articles:
                self.update(article)
            self.stdout.write('*********finish num: %d' % len(articles))
            index += 1
            articles = all_articles[index * _max_num: (index + 1) * _max_num]

    def update(self, article):
        images = TopicImage.objects.filter(topic_id=article.id)
        if len(images) == 1 and not images[0].is_cover:
            images[0].is_cover = True
            images[0].save()
            self.stdout.write('finish topic: %s' % article.id)
        else:
            self.stdout.write('done with notion todo!')
