#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
from django.core.management.base import BaseCommand

from gm_types.gaia import (
    AGILE_TAG_HERA_RECOMMEND_TAB_TYPE,
    AGILE_TAG_RECOMMEND_TYPE,
)

from agile.models import AgileTagHeraRecommend

tab_type_mapping_tags = {
    (AGILE_TAG_RECOMMEND_TYPE.TRACTATE, AGILE_TAG_HERA_RECOMMEND_TAB_TYPE.ALL):  # 全部
        [9535, 9510, 9669, 9670, 9509, 9532, 9518, 9508, 9505, 9511, 8, 21, 117, 31, 61],
    (AGILE_TAG_RECOMMEND_TYPE.TRACTATE, AGILE_TAG_HERA_RECOMMEND_TAB_TYPE.PROJECT):  # 项目
        [117, 31, 1, 50, 35, 8, 21, 4, 28, 64, 60, 7, 61, 37, 4],
    (AGILE_TAG_RECOMMEND_TYPE.TRACTATE, AGILE_TAG_HERA_RECOMMEND_TAB_TYPE.POSITION):  # 部位
        [169, 156, 120, 124, 332, 331, 330, 329, 306, 310, 303, 278, 360, 265, 271],
    (AGILE_TAG_RECOMMEND_TYPE.TRACTATE, AGILE_TAG_HERA_RECOMMEND_TAB_TYPE.BRAND):  # 品牌
        [342, 344, 184, 168, 315, 294, 181, 190, 214, 309, 289],
    (AGILE_TAG_RECOMMEND_TYPE.TRACTATE, AGILE_TAG_HERA_RECOMMEND_TAB_TYPE.INSTRUMENT):  # 仪器
        [223, 218, 122, 318, 324, 280, 251, 166],
}


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        print("BEGIN")
        bulk_create_list = []
        for k, v in tab_type_mapping_tags.items():
            _recommend_type, _tab_type = k

            base_kw = {
                "agile_recommend_type": _recommend_type,
                "agile_tab_type": _tab_type,
                "is_online": True,
            }

            if AgileTagHeraRecommend.objects.filter(**base_kw).exists():

                print("recommend_type {}、tab_type {} exists!".format(
                    AGILE_TAG_RECOMMEND_TYPE.getDesc(_recommend_type),
                    AGILE_TAG_HERA_RECOMMEND_TAB_TYPE.getDesc(_tab_type)
                ))

                continue
            else:
                base_kw.update({
                    "agile_tag_sort_ids": json.dumps(v),
                })
                bulk_create_list.append(AgileTagHeraRecommend(**base_kw))

                print("recommend_type {}、tab_type {} will create!".format(
                    AGILE_TAG_RECOMMEND_TYPE.getDesc(_recommend_type),
                    AGILE_TAG_HERA_RECOMMEND_TAB_TYPE.getDesc(_tab_type)
                ))

        if bulk_create_list:
            print("bulk create, lens {}".format(len(bulk_create_list)))
            AgileTagHeraRecommend.objects.bulk_create(bulk_create_list)

        print("END")
